#ifndef _MATRIX_H_
#define _MATRIX_H_

#include <iostream>
#include <cstring>


template <class T> class Matrix;
template <class T>
std::ostream& operator<<(std::ostream& os, const Matrix<T>& x);

template <class T>
class Matrix {
 public:
  Matrix(int32_t rows, int32_t cols);
  Matrix(const Matrix &a);
  ~Matrix();

  T& operator()(size_t i, size_t j);
  T operator()(size_t i, size_t j) const;

  Matrix<T>& operator*=(T a);

  friend std::ostream& operator<< <>(std::ostream& os, const Matrix<T>& x);

 private:
  int32_t mRows;
  int32_t mCols;
  T* mData;
};

template <class T>
Matrix<T>::Matrix(int32_t rows, int32_t cols) : mRows(rows), mCols(cols) {
  mData = new T[rows * cols]();
}

template <class T>
Matrix<T>::Matrix(const Matrix &a) {
  mRows = a.mRows;
  mCols = a.mCols;
  mData = new T[mRows * mCols];
  memcpy(mData, a.mData, mRows * mCols * sizeof(T));
}

template <class T>
Matrix<T>::~Matrix() {
  delete[] mData;
}

template <class T>
T& Matrix<T>::operator()(size_t i, size_t j) {
  return mData[i * mCols + j];
}

template <class T>
T Matrix<T>::operator()(size_t i, size_t j) const {
  return mData[i * mCols + j];
}

template <class T>
Matrix<T>& Matrix<T>::operator*=(T a) {
  for (int i = 0; i < mRows*mCols; i++)
    mData[i] *= a;
  return *this;
}

template <class T>
std::ostream& operator<<(std::ostream& os, const Matrix<T>& x) {
  for (int i = 0; i < x.mRows; i++) {
    for (int j = 0; j < x.mCols; j++)
      os << x.mData[i * x.mCols + j] << " ";
    if (i+1 < x.mRows)
      os << std::endl;
  }
  return os;
}

#endif  // _MATRIX_H_
