#ifndef _MATRIX_H_
#define _MATRIX_H_

#include <iostream>
#include <cstring>


template <class T>
class Matrix {
 public:
  Matrix(int32_t rows, int32_t cols) : mRows(rows), mCols(cols) {
    mData = new T[rows * cols]();
  }
  Matrix(const Matrix &a) {
    mRows = a.mRows;
    mCols = a.mCols;
    mData = new T[mRows * mCols];
    memcpy(mData, a.mData, mRows * mCols * sizeof(T));
  }
  ~Matrix() {
    delete[] mData;
  }

  T& operator()(size_t i, size_t j) {
    return mData[i * mCols + j];
  }
  T operator()(size_t i, size_t j) const {
    return mData[i * mCols + j];
  }

  Matrix<T>& operator*=(T a) {
    for (int i = 0; i < mRows*mCols; i++)
      mData[i] *= a;
    return *this;
  }

  friend std::ostream& operator<<(std::ostream& os, const Matrix<T>& x) {
    for (int i = 0; i < x.mRows; i++) {
      for (int j = 0; j < x.mCols; j++)
        os << x.mData[i * x.mCols + j] << " ";
      if (i+1 < x.mRows)
        os << std::endl;
    }
    return os;
  }

 private:
  int32_t mRows;
  int32_t mCols;
  T* mData;
};

#endif  // _MATRIX_H_
